/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.listeners;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import ws.hypha.blockplayerplugin.BlockPlayerPlugin;

public class PrivateMessageListener
implements Listener {
    private final BlockPlayerPlugin plugin;

    public PrivateMessageListener(BlockPlayerPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase();
        if (message.startsWith("/msg ") || message.startsWith("/tell ") || message.startsWith("/w ") || message.startsWith("/whisper ")) {
            String[] parts = event.getMessage().split(" ", 3);
            if (parts.length < 3) {
                return;
            }
            Player sender = event.getPlayer();
            Player recipient = Bukkit.getPlayer((String)parts[1]);
            if (recipient == null) {
                return;
            }
            boolean senderBlockedRecipient = this.plugin.getDatabaseManager().isPlayerBlocked(sender.getUniqueId(), recipient.getUniqueId());
            boolean recipientBlockedSender = this.plugin.getDatabaseManager().isPlayerBlocked(recipient.getUniqueId(), sender.getUniqueId());
            if (senderBlockedRecipient || recipientBlockedSender) {
                event.setCancelled(true);
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You cannot send a message to this player.");
            }
        }
    }
}

