/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.listeners;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import ws.hypha.blockplayerplugin.BlockPlayerPlugin;

public class PlayerVisibilityListener
implements Listener {
    private final BlockPlayerPlugin plugin;

    public PlayerVisibilityListener(BlockPlayerPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player joiningPlayer = event.getPlayer();
        this.plugin.getLogger().info("Player " + joiningPlayer.getName() + " joining. Processing visibility and join message.");
        String joinMessage = event.getJoinMessage();
        event.setJoinMessage(null);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.getUniqueId().equals(joiningPlayer.getUniqueId())) {
                if (joinMessage == null || joinMessage.isEmpty()) continue;
                joiningPlayer.sendMessage(joinMessage);
                continue;
            }
            this.updateVisibility(joiningPlayer, onlinePlayer);
            boolean player1BlockedPlayer2 = this.plugin.getDatabaseManager().isPlayerBlocked(joiningPlayer.getUniqueId(), onlinePlayer.getUniqueId());
            boolean player2BlockedPlayer1 = this.plugin.getDatabaseManager().isPlayerBlocked(onlinePlayer.getUniqueId(), joiningPlayer.getUniqueId());
            if (player1BlockedPlayer2 || player2BlockedPlayer1 || joinMessage == null || joinMessage.isEmpty()) continue;
            onlinePlayer.sendMessage(joinMessage);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player quittingPlayer = event.getPlayer();
        this.plugin.getLogger().info("Player " + quittingPlayer.getName() + " quitting. Processing quit message.");
        String quitMessage = event.getQuitMessage();
        event.setQuitMessage(null);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.getUniqueId().equals(quittingPlayer.getUniqueId())) continue;
            boolean player1BlockedPlayer2 = this.plugin.getDatabaseManager().isPlayerBlocked(quittingPlayer.getUniqueId(), onlinePlayer.getUniqueId());
            boolean player2BlockedPlayer1 = this.plugin.getDatabaseManager().isPlayerBlocked(onlinePlayer.getUniqueId(), quittingPlayer.getUniqueId());
            if (player1BlockedPlayer2 || player2BlockedPlayer1 || quitMessage == null || quitMessage.isEmpty()) continue;
            onlinePlayer.sendMessage(quitMessage);
        }
    }

    public void updateVisibility(Player player1, Player player2) {
        if (player1 == null || !player1.isOnline() || player2 == null || !player2.isOnline()) {
            return;
        }
        if (player1.getUniqueId().equals(player2.getUniqueId())) {
            return;
        }
        boolean p1BlockedP2 = this.plugin.getDatabaseManager().isPlayerBlocked(player1.getUniqueId(), player2.getUniqueId());
        boolean p2BlockedP1 = this.plugin.getDatabaseManager().isPlayerBlocked(player2.getUniqueId(), player1.getUniqueId());
        boolean p1HasBypass = player1.hasPermission("blockplayer.bypass");
        boolean p2HasBypass = player2.hasPermission("blockplayer.bypass");
        if (p1BlockedP2 || p2BlockedP1 && !p1HasBypass) {
            if (player1.canSee(player2)) {
                player1.hidePlayer((Plugin)this.plugin, player2);
                this.plugin.getLogger().info("Visibility: " + player1.getName() + " is now hiding " + player2.getName());
            }
        } else if (!player1.canSee(player2)) {
            player1.showPlayer((Plugin)this.plugin, player2);
            this.plugin.getLogger().info("Visibility: " + player1.getName() + " is now showing " + player2.getName());
        }
        if (p2BlockedP1 || p1BlockedP2 && !p2HasBypass) {
            if (player2.canSee(player1)) {
                player2.hidePlayer((Plugin)this.plugin, player1);
                this.plugin.getLogger().info("Visibility: " + player2.getName() + " is now hiding " + player1.getName());
            }
        } else if (!player2.canSee(player1)) {
            player2.showPlayer((Plugin)this.plugin, player1);
            this.plugin.getLogger().info("Visibility: " + player2.getName() + " is now showing " + player1.getName());
        }
    }
}

