/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.listeners;

import java.util.Iterator;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import ws.hypha.blockplayerplugin.BlockPlayerPlugin;

public class ChatListener
implements Listener {
    private final BlockPlayerPlugin plugin;

    public ChatListener(BlockPlayerPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        Iterator recipients = event.getRecipients().iterator();
        while (recipients.hasNext()) {
            Player recipient = (Player)recipients.next();
            if (sender.equals((Object)recipient)) continue;
            boolean senderBlockedRecipient = this.plugin.getDatabaseManager().isPlayerBlocked(sender.getUniqueId(), recipient.getUniqueId());
            boolean recipientBlockedSender = this.plugin.getDatabaseManager().isPlayerBlocked(recipient.getUniqueId(), sender.getUniqueId());
            if (!senderBlockedRecipient && !recipientBlockedSender) continue;
            recipients.remove();
        }
    }
}

