/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private Connection connection;
    private final String dbName = "blockplayer.db";

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.plugin.getDataFolder().getAbsolutePath() + "/blockplayer.db");
            try (Statement statement = this.connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS blocked_players (blocker_uuid TEXT, blocked_uuid TEXT, PRIMARY KEY (blocker_uuid, blocked_uuid))");
            }
            this.plugin.getLogger().info("Database connection established to blockplayer.db");
        }
        catch (ClassNotFoundException | SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.plugin.getLogger().info("Database connection closed.");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error closing database connection", e);
        }
    }

    public boolean addBlockedPlayer(UUID blockerUUID, UUID blockedUUID) {
        boolean bl;
        block8: {
            PreparedStatement ps = this.connection.prepareStatement("INSERT OR IGNORE INTO blocked_players (blocker_uuid, blocked_uuid) VALUES (?, ?)");
            try {
                ps.setString(1, blockerUUID.toString());
                ps.setString(2, blockedUUID.toString());
                boolean bl2 = bl = ps.executeUpdate() > 0;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error adding blocked player: " + String.valueOf(blockerUUID) + " -> " + String.valueOf(blockedUUID), e);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    public boolean removeBlockedPlayer(UUID blockerUUID, UUID blockedUUID) {
        boolean bl;
        block8: {
            PreparedStatement ps = this.connection.prepareStatement("DELETE FROM blocked_players WHERE blocker_uuid = ? AND blocked_uuid = ?");
            try {
                ps.setString(1, blockerUUID.toString());
                ps.setString(2, blockedUUID.toString());
                boolean bl2 = bl = ps.executeUpdate() > 0;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error removing blocked player: " + String.valueOf(blockerUUID) + " -> " + String.valueOf(blockedUUID), e);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isPlayerBlocked(UUID blockerUUID, UUID blockedUUID) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT 1 FROM blocked_players WHERE blocker_uuid = ? AND blocked_uuid = ?");){
            boolean bl;
            block14: {
                ps.setString(1, blockerUUID.toString());
                ps.setString(2, blockedUUID.toString());
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error checking if player is blocked: " + String.valueOf(blockerUUID) + " by " + String.valueOf(blockedUUID), e);
            return false;
        }
    }

    public Set<UUID> getBlockedPlayers(UUID blockerUUID) {
        HashSet<UUID> blockedPlayers = new HashSet<UUID>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT blocked_uuid FROM blocked_players WHERE blocker_uuid = ?");){
            ps.setString(1, blockerUUID.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    blockedPlayers.add(UUID.fromString(rs.getString("blocked_uuid")));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting blocked players for: " + String.valueOf(blockerUUID), e);
        }
        return blockedPlayers;
    }

    public Set<UUID> getBlockersOf(UUID blockedUUID) {
        HashSet<UUID> blockers = new HashSet<UUID>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT blocker_uuid FROM blocked_players WHERE blocked_uuid = ?");){
            ps.setString(1, blockedUUID.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    blockers.add(UUID.fromString(rs.getString("blocker_uuid")));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting blockers of: " + String.valueOf(blockedUUID), e);
        }
        return blockers;
    }
}

