/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import ws.hypha.blockplayerplugin.BlockPlayerPlugin;

public class UnblockTabCompleter
implements TabCompleter {
    private final BlockPlayerPlugin plugin;

    public UnblockTabCompleter(BlockPlayerPlugin plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return completions;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            String currentArg = args[0].toLowerCase();
            Set<UUID> blockedUUIDs = this.plugin.getDatabaseManager().getBlockedPlayers(player.getUniqueId());
            List blockedPlayerNames = blockedUUIDs.stream().map(uuid -> {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                return offlinePlayer != null ? offlinePlayer.getName() : null;
            }).filter(name -> name != null && !name.isEmpty()).collect(Collectors.toList());
            StringUtil.copyPartialMatches((String)currentArg, blockedPlayerNames, completions);
        }
        return completions;
    }
}

