/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.commands;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import ws.hypha.blockplayerplugin.BlockPlayerPlugin;
import ws.hypha.blockplayerplugin.listeners.PlayerVisibilityListener;

public class UnblockCommand
implements CommandExecutor {
    private final BlockPlayerPlugin plugin;

    public UnblockCommand(BlockPlayerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        UUID targetUUID;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("blockplayer.unblock")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /unblock <playername>");
            return true;
        }
        String targetName = args[0];
        Player targetOnlinePlayer = Bukkit.getPlayer((String)targetName);
        if (targetOnlinePlayer != null) {
            targetUUID = targetOnlinePlayer.getUniqueId();
        } else {
            OfflinePlayer targetOfflinePlayer = Bukkit.getOfflinePlayer((String)targetName);
            if (targetOfflinePlayer == null || !targetOfflinePlayer.hasPlayedBefore()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player " + targetName + " not found.");
                return true;
            }
            targetUUID = targetOfflinePlayer.getUniqueId();
        }
        if (!this.plugin.getDatabaseManager().isPlayerBlocked(player.getUniqueId(), targetUUID)) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + targetName + " is not on your block list.");
            return true;
        }
        boolean success = this.plugin.getDatabaseManager().removeBlockedPlayer(player.getUniqueId(), targetUUID);
        if (success) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have unblocked " + targetName + ".");
            if (targetOnlinePlayer != null && targetOnlinePlayer.isOnline()) {
                PlayerVisibilityListener pvl = this.getPlayerVisibilityListener();
                if (pvl != null) {
                    pvl.updateVisibility(player, targetOnlinePlayer);
                } else {
                    player.showPlayer((Plugin)this.plugin, targetOnlinePlayer);
                    if (targetOnlinePlayer.isOnline()) {
                        targetOnlinePlayer.showPlayer((Plugin)this.plugin, player);
                    }
                }
            }
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to unblock player. Please try again.");
        return false;
    }

    private PlayerVisibilityListener getPlayerVisibilityListener() {
        for (RegisteredListener registeredListener : HandlerList.getRegisteredListeners((Plugin)this.plugin)) {
            if (!(registeredListener.getListener() instanceof PlayerVisibilityListener)) continue;
            return (PlayerVisibilityListener)registeredListener.getListener();
        }
        this.plugin.getLogger().warning("PlayerVisibilityListener instance not found for UnblockCommand. Visibility may not update immediately for online players.");
        return null;
    }
}

