/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.commands;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ws.hypha.blockplayerplugin.BlockPlayerPlugin;

public class BlockListCommand
implements CommandExecutor {
    private final BlockPlayerPlugin plugin;

    public BlockListCommand(BlockPlayerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player) && args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command must be run by a player to see their own blocklist, or specify a player name.");
            return true;
        }
        if (args.length == 0) {
            Player player = (Player)sender;
            if (!player.hasPermission("blockplayer.blocklist")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to view your blocklist.");
                return true;
            }
            this.displayBlocklist((CommandSender)player, player.getUniqueId(), player.getName());
            return true;
        }
        if (args.length == 1) {
            if (!sender.hasPermission("blockplayer.blocklist.others")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to view other players' blocklists.");
                return true;
            }
            String targetName = args[0];
            OfflinePlayer targetOfflinePlayer = Bukkit.getOfflinePlayer((String)targetName);
            if (!targetOfflinePlayer.hasPlayedBefore()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + targetName + " not found or has never played on this server.");
                return true;
            }
            this.displayBlocklist(sender, targetOfflinePlayer.getUniqueId(), targetOfflinePlayer.getName());
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /blocklist [playername]");
        return true;
    }

    private void displayBlocklist(CommandSender sender, UUID listOwnerUUID, String listOwnerName) {
        Set<UUID> blockedUUIDs = this.plugin.getDatabaseManager().getBlockedPlayers(listOwnerUUID);
        if (blockedUUIDs.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + (String)(sender.getName().equals(listOwnerName) ? "Your" : listOwnerName + "'s") + " blocklist is empty.");
            return;
        }
        String blockedPlayerNames = blockedUUIDs.stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName()).filter(name -> name != null && !name.isEmpty()).collect(Collectors.joining(", "));
        if (blockedPlayerNames.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + (String)(sender.getName().equals(listOwnerName) ? "Your" : listOwnerName + "'s") + " blocklist contains players whose names could not be retrieved.");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + (String)(sender.getName().equals(listOwnerName) ? "Your" : listOwnerName + "'s") + " blocklist (" + blockedUUIDs.size() + "):");
            sender.sendMessage(String.valueOf(ChatColor.WHITE) + blockedPlayerNames);
        }
    }
}

