/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin.commands;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ws.hypha.blockplayerplugin.BlockPlayerPlugin;
import ws.hypha.blockplayerplugin.BlocklistLimit;

public class BlockCommand
implements CommandExecutor {
    private final BlockPlayerPlugin plugin;

    public BlockCommand(BlockPlayerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int currentBlockCount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("blockplayer.block")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /block <playername>");
            return true;
        }
        int blockLimit = BlocklistLimit.getBlocklistLimit();
        if (blockLimit < Integer.MAX_VALUE && (currentBlockCount = this.plugin.getDatabaseManager().getBlockedPlayers(player.getUniqueId()).size()) >= blockLimit) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "BlockPlayerLite: You can only block " + blockLimit + " player(s) at a time.");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer targetPlayer = null;
        try {
            targetPlayer = Bukkit.getOfflinePlayer((String)targetName);
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Could not find a player with that name.");
            Bukkit.getLogger().warning("[BlockPlayer] Could not find profile with name: " + targetName);
            return true;
        }
        Player targetOnlinePlayer = Bukkit.getPlayer((String)targetName);
        if (targetOnlinePlayer == null && !targetPlayer.hasPlayedBefore()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Could not find a player with that name.");
            Bukkit.getLogger().warning("[BlockPlayer] Could not find profile with name: " + targetName);
            return true;
        }
        UUID targetUUID = targetPlayer.getUniqueId();
        String actualTargetName = targetName;
        if (player.getUniqueId().equals(targetUUID)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot block yourself.");
            return true;
        }
        if (this.plugin.getDatabaseManager().isPlayerBlocked(player.getUniqueId(), targetUUID)) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + actualTargetName + " is already blocked.");
            return true;
        }
        boolean success = this.plugin.getDatabaseManager().addBlockedPlayer(player.getUniqueId(), targetUUID);
        if (success) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have blocked " + actualTargetName + ".");
            if (targetOnlinePlayer != null && targetOnlinePlayer.isOnline()) {
                player.hidePlayer((Plugin)this.plugin, targetOnlinePlayer);
                if (!targetOnlinePlayer.hasPermission("blockplayer.bypass")) {
                    targetOnlinePlayer.hidePlayer((Plugin)this.plugin, player);
                }
            }
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to block player. Please try again.");
        return false;
    }
}

