/*
 * Decompiled with CFR 0.152.
 */
package ws.hypha.blockplayerplugin;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ws.hypha.blockplayerplugin.commands.BlockCommand;
import ws.hypha.blockplayerplugin.commands.BlockListCommand;
import ws.hypha.blockplayerplugin.commands.UnblockCommand;
import ws.hypha.blockplayerplugin.commands.UnblockTabCompleter;
import ws.hypha.blockplayerplugin.data.DatabaseManager;
import ws.hypha.blockplayerplugin.listeners.ChatListener;
import ws.hypha.blockplayerplugin.listeners.PlayerMessageListener;
import ws.hypha.blockplayerplugin.listeners.PlayerVisibilityListener;
import ws.hypha.blockplayerplugin.listeners.PrivateMessageListener;

public class BlockPlayerPlugin
extends JavaPlugin {
    private DatabaseManager databaseManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        this.getCommand("block").setExecutor((CommandExecutor)new BlockCommand(this));
        this.getCommand("unblock").setExecutor((CommandExecutor)new UnblockCommand(this));
        this.getCommand("blocklist").setExecutor((CommandExecutor)new BlockListCommand(this));
        this.getCommand("unblock").setTabCompleter((TabCompleter)new UnblockTabCompleter(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerVisibilityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMessageListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PrivateMessageListener(this), (Plugin)this);
        this.getLogger().info("BlockPlayer plugin has been enabled!");
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("BlockPlayer plugin has been disabled!");
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }
}

